#pragma once
#include "functions.h"

class activ_function
{
public:
	void apply(gsl_matrix *m);
	void apply(gsl_vector *v);
	virtual double actFunction(double x);
	virtual double actFunction_inv(double x);
	virtual double actFunction_deriv(double y);
	void applySoftmax(gsl_matrix *m);
	void applySoftmax(gsl_vector *v);
};

class activ_function_linear: public activ_function
{
public:
	double actFunction(double x);
	double actFunction_inv(double x);
	double actFunction_deriv(double y);
};

class activ_function_tanh: public activ_function
{
public:
	double actFunction(double x);
	double actFunction_inv(double x);
	double actFunction_deriv(double y);
};

class activ_function_logistic: public activ_function
{
public:
	double actFunction(double x);
	double actFunction_inv(double x);
	double actFunction_deriv(double y);
};